<?php
require_once("config.php");

$token = BOT_TOKEN;
$update = json_decode(file_get_contents("php://input"), true);

$chat_id = $update["message"]["chat"]["id"] ?? $update["callback_query"]["message"]["chat"]["id"];
$message_id = $update["callback_query"]["message"]["message_id"] ?? null;
$data = $update["callback_query"]["data"] ?? null;
$text = $update["message"]["text"] ?? null;

$user = $update["message"]["from"] ?? $update["callback_query"]["from"];
$first = $user["first_name"] ?? "";
$last = $user["last_name"] ?? "";
$username = isset($user["username"]) ? "@".$user["username"] : "N/A";
$user_id = $user["id"];

registerUser($user_id, trim("$first $last"), $username); // store in user_data.json

$issues = json_decode(file_get_contents("issues.json"), true);

// --- Main logic ---

if ($text == "/main") {
    sendMainMenu($chat_id);
}
elseif ($text == "/start") {
    sendStartMessage($chat_id);
}
elseif ($text == "/help") {
    sendHelpMessage($chat_id);
}

// ADMIN PANEL
elseif ($text == "/admin" && $chat_id == ADMIN_CHAT_ID) {
    adminMenu($chat_id);
}
elseif ($text == "/send" && $chat_id == ADMIN_CHAT_ID) {
    file_put_contents(LOG_PATH . "send_state.json", json_encode(["step" => "await_user"]));
    sendMessage($chat_id, "👤 Enter the Telegram user ID you want to message:");
}

// Broadcast start
elseif ($text && file_exists(LOG_PATH . "broadcast_state.json") && $chat_id == ADMIN_CHAT_ID) {
    $data = json_decode(file_get_contents(LOG_PATH . "broadcast_state.json"), true);
    if ($data["step"] == "await_message") {
        unlink(LOG_PATH . "broadcast_state.json");
        broadcastMessage($text);
        sendMessage($chat_id, "✅ Broadcast sent to all users.");
    }
}
// Handle /send user message flow
elseif ($text && file_exists(LOG_PATH . "send_state.json") && $chat_id == ADMIN_CHAT_ID) {
    $state = json_decode(file_get_contents(LOG_PATH . "send_state.json"), true);

    // Step 1 — Get user ID
    if ($state["step"] == "await_user") {
        $state["user_id"] = trim($text);
        $state["step"] = "await_message";
        file_put_contents(LOG_PATH . "send_state.json", json_encode($state));
        sendMessage($chat_id, "💬 Now enter the message you want to send to <b>{$state['user_id']}</b>:");
    }

    // Step 2 — Get message and send
    elseif ($state["step"] == "await_message") {
        $user_id = $state["user_id"];
        unlink(LOG_PATH . "send_state.json");

        $ok = sendMessage($user_id, $text);
        if ($ok) {
            sendMessage($chat_id, "✅ Message sent to user ID: $user_id");
        } else {
            sendMessage($chat_id, "❌ Failed to send. The user might have blocked the bot or never started it.");
        }
    }
}


// Callback button press
elseif ($data) {
    handleCallback($chat_id, $message_id, $data);
}

// UID submission
elseif (file_exists(LOG_PATH . "state_$chat_id.json")) {
    $state = json_decode(file_get_contents(LOG_PATH . "state_$chat_id.json"), true);
    $ticket = strtoupper(substr(md5(time() . rand()), 0, 6));

    $reply = "✅ Your issue: {$state['issue']}\n🆔 UID: $text\n🎟 Ticket number: #TCK$ticket";
    sendMessage($chat_id, $reply);

    $adminMsg = "📩 <b>New Support Ticket</b>\n\n"
        ."👤 <b>Name:</b> $first $last\n"
        ."🔗 <b>Telegram:</b> <a href='tg://user?id=$user_id'>$username</a>\n"
        ."🆔 <b>ID:</b> $user_id\n\n"
        ."✅ <b>Issue:</b> {$state['issue']}\n"
        ."🆔 <b>UID:</b> $text\n"
        ."🎟 <b>Ticket:</b> #TCK$ticket\n"
        ."<b>Current Status:</b> Pending | Resolved | Rejected";


    $buttons = [
        [
            ["text" => "✅ Mark Resolved", "callback_data" => "status|resolved|$ticket"],
            ["text" => "⏳ Pending", "callback_data" => "status|pending|$ticket"],
            ["text" => "❌ Rejected", "callback_data" => "status|rejected|$ticket"]
        ]
    ];
    sendMessage(ADMIN_CHAT_ID, $adminMsg, $buttons);

    saveIssue([
        "ticket" => "#TCK$ticket",
        "user_id" => $user_id,
        "name" => trim("$first $last"),
        "username" => $username,
        "issue" => $state["issue"],
        "uid" => $text,
        "status" => "pending",
        "timestamp" => date("Y-m-d H:i:s")
    ]);

    unlink(LOG_PATH . "state_$chat_id.json");
}
// --- NEW: Unknown text triggers Main Menu ---
else {
    sendMainMenu($chat_id);
}

// =============== FUNCTIONS ===============

function sendMainMenu($chat_id) {
    global $issues;
    $keyboard = [];
    $i = 1;
    foreach (array_keys($issues) as $cat) {
        $keyboard[] = [["text" => "$i. $cat", "callback_data" => "cat|" . urlencode($cat)]];
        $i++;
    }
    $msg = "👋 Hello! Thank you for contacting us.\nPlease select the type of issue you are experiencing:";
    sendMessage($chat_id, $msg, $keyboard);
}

function handleCallback($chat_id, $message_id, $data) {
    global $issues;

    $parts = explode("|", $data);
    $type = $parts[0];

    if ($type == "cat") {
        $cat = urldecode($parts[1]);
        $subs = $issues[$cat];

        if (isset($subs["_direct_reply"])) {
            file_put_contents(LOG_PATH . "state_$chat_id.json", json_encode(["issue" => $cat]));
            editMessage($chat_id, $message_id, $subs["_direct_reply"]);
            return;
        }

        $keyboard = [];
        $i = 1;
        foreach ($subs as $sub => $details) {
            if ($sub == "_direct_reply") continue;
            $keyboard[] = [["text" => "$i. $sub", "callback_data" => "sub|" . urlencode("$cat>$sub")]];
            $i++;
        }
        $keyboard[] = [["text" => "⬅️ Back", "callback_data" => "back"]];
        editMessage($chat_id, $message_id, "Select a sub-issue under <b>$cat</b>:", $keyboard);
    }

    elseif ($type == "sub") {
        [$cat, $sub] = explode(">", urldecode($parts[1]), 2);
        $template = $issues[$cat][$sub]["_reply_template"];
        file_put_contents(LOG_PATH . "state_$chat_id.json", json_encode(["issue" => "$sub >> $cat"]));
        editMessage($chat_id, $message_id, $template);
    }

elseif ($type == "status" && $chat_id == ADMIN_CHAT_ID) {
    $status = ucfirst($parts[1]); // resolved / pending / rejected
    $ticket = "#TCK" . $parts[2];

    updateIssueStatus($ticket, strtolower($status));

    // Get the original message text from callback
    $message = $GLOBALS["update"]["callback_query"]["message"]["text"] ?? null;

    if ($message) {
        // Dynamically build a highlighted status line
        $statuses = ["Pending", "Resolved", "Rejected"];
        $statusLine = "<b>Current Status:</b> ";
        foreach ($statuses as $s) {
            if (strtolower($s) == strtolower($status)) {
                $statusLine .= "✅ <b>$s</b> ";
            } else {
                $statusLine .= "$s ";
            }
        }

        // Replace old line with new status line
        $newMessage = preg_replace(
            "/Current Status:.*/i",
            $statusLine,
            $message
        );

        // Reapply inline buttons
        $buttons = [
            [
                ["text" => "✅ Mark Resolved", "callback_data" => "status|resolved|{$parts[2]}"],
                ["text" => "⏳ Pending", "callback_data" => "status|pending|{$parts[2]}"],
                ["text" => "❌ Rejected", "callback_data" => "status|rejected|{$parts[2]}"]
            ]
        ];

        editMessage($chat_id, $message_id, $newMessage, $buttons);
    }
}



    elseif ($type == "admin") {
        adminAction($parts[1], $chat_id);
    }

    elseif ($type == "back") {
        sendMainMenu($chat_id);
    }
    elseif ($data == "help") {
    sendHelpMessage($chat_id);
}

}

// --- Admin actions ---

function adminMenu($chat_id) {
    $buttons = [
        [["text" => "📤 Send Message to User", "callback_data" => "admin|senduser"]],

        [["text" => "📊 Stats", "callback_data" => "admin|stats"]],
        [["text" => "📬 Broadcast Message", "callback_data" => "admin|broadcast"]],
        [["text" => "📁 View Issues", "callback_data" => "admin|issues"]]
    ];
    sendMessage($chat_id, "👑 <b>Admin Panel</b>", $buttons);
}

function adminAction($action, $chat_id) {
    if ($action == "broadcast") {
        file_put_contents(LOG_PATH . "broadcast_state.json", json_encode(["step" => "await_message"]));
        sendMessage($chat_id, "✍️ Send the message you want to broadcast to all users.");
    } elseif ($action == "stats") {
        $data = getIssueStats();
        $msg = "📊 <b>Bot Statistics</b>\n\n"
             ."👥 Users: {$data['users']}\n"
             ."📋 Total Issues: {$data['total']}\n"
             ."✅ Resolved: {$data['resolved']}\n"
             ."⏳ Pending: {$data['pending']}\n"
             ."❌ Rejected: {$data['rejected']}";
        sendMessage($chat_id, $msg);
    } elseif ($action == "issues") {
        $data = json_decode(file_get_contents(USER_ISSUE_FILE), true) ?? [];
        $msg = "📁 <b>Last 5 Issues:</b>\n\n";
        foreach (array_slice(array_reverse($data), 0, 5) as $i) {
            $msg .= "🎟 {$i['ticket']} | {$i['status']}\n👤 {$i['name']} ({$i['username']})\n\n";
        }
        sendMessage($chat_id, $msg);
    }
    elseif ($action == "senduser") {
    file_put_contents(LOG_PATH . "send_state.json", json_encode(["step" => "await_user"]));
    sendMessage($chat_id, "👤 Enter the Telegram user ID you want to message:");
}

}

// --- Utilities ---

function sendStartMessage($chat_id) {
    $token = BOT_TOKEN; // your bot token
    $url = "https://api.telegram.org/bot$token/sendPhoto";

    $photo = "https://i.ibb.co/JWvrHw3T/Picsart-25-11-09-14-02-10-130.png";
    $caption = "<b>💫 𝐎𝐧𝐞 𝐂𝐨𝐢𝐧 𝐏𝐚𝐲 — 𝐅𝐚𝐬𝐭 𝟐𝟒/𝟕 𝐒𝐮𝐩𝐩𝐨𝐫𝐭 🤝</b>\n\n"
        . "<b>🔐 𝐀𝐜𝐜𝐨𝐮𝐧𝐭 • 𝐎𝐫𝐝𝐞𝐫 • 𝐑𝐞𝐜𝐡𝐚𝐫𝐠𝐞 𝐅𝐢𝐱</b>\n\n"
        . "<b>💼 𝐒𝐚𝐥𝐞𝐬 • 𝐖𝐚𝐥𝐥𝐞𝐭 • 𝐁𝐚𝐥𝐚𝐧𝐜𝐞 𝐇𝐞𝐥𝐩 ⚡</b>\n\n"
        . "<b>📩 𝐀𝐥𝐞𝐫𝐭 • 𝐑𝐞𝐦𝐢𝐧𝐝𝐞𝐫 • 𝐆𝐥𝐢𝐭𝐜𝐡 𝐅𝐢𝐱</b>\n\n"
        . "<b>✅ 𝐅𝐚𝐬𝐭 • 𝐒𝐞𝐜𝐮𝐫𝐞 • 𝐑𝐞𝐚𝐥-𝐓𝐢𝐦𝐞</b>\n\n"
        . "<b>💎 𝐀𝐥𝐥 𝐈𝐬𝐬𝐮𝐞𝐬 — 𝐎𝐧𝐞 𝐓𝐚𝐩 𝐒𝐨𝐥𝐯𝐞 ⚙️</b>";

    $keyboard = [
        "inline_keyboard" => [
            [
                ["text" => "💥 𝐎𝐧𝐞-𝐂𝐨𝐢𝐧 𝐏𝐚𝐲 💥", "url" => "https://t.me/OneCoinPayIndustry"]
            ],
            [
                ["text" => "Support", "callback_data" => "help"]
            ]
        ]
    ];

    $post_fields = [
        "chat_id" => $chat_id,
        "photo" => $photo,
        "caption" => $caption,
        "parse_mode" => "HTML",
        "disable_web_page_preview" => true,
        "reply_markup" => json_encode($keyboard)
    ];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $post_fields);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $response = curl_exec($ch);
    curl_close($ch);

    $res = json_decode($response, true);
    return isset($res["ok"]) && $res["ok"] === true;
}
function sendHelpMessage($chat_id) {
    $token = BOT_TOKEN; // Replace with your bot token
    $url = "https://api.telegram.org/bot$token/sendPhoto";

    $photo = "https://i.ibb.co/DHKGCW1D/1000006942.png";
  $caption = "<b>🚀 𝗪𝗘𝗟𝗖𝗢𝗠𝗘 𝗧𝗢 𝗦𝗘𝗟𝗙-𝗦𝗘𝗥𝗩𝗜𝗖𝗘 𝗩𝗔𝗨𝗟𝗧!</b>\n\n"
        . "💼 <b>𝗣𝗿𝗼 𝗠𝗲𝗿𝗰𝗵𝗮𝗻𝘁 • 𝗖𝘂𝘀𝘁𝗼𝗺𝗲𝗿 𝗦𝗲𝗿𝘃𝗶𝗰𝗲 • 𝗙𝘂𝗻𝗱𝘀 𝗖𝗲𝗻𝘁𝗲𝗿</b>\n\n"
        . "<b>🔍 𝗛𝗢𝗪 𝗧𝗢 𝗨𝗦𝗘</b>\n"
        . "👉 𝗦𝗲𝗹𝗲𝗰𝘁 𝘆𝗼𝘂𝗿 𝗣𝗿𝗼𝗯𝗹𝗲𝗺 / 𝗜𝘀𝘀𝘂𝗲, <b>𝗦𝗲𝗻𝗱 𝗬𝗼𝘂𝗿 𝗨𝗜𝗗</b> 𝗮𝗻𝗱 <b>𝗚𝗲𝘁 𝗜𝗻𝘀𝘁𝗮𝗻𝘁 𝗛𝗲𝗹𝗽 🔎</b>\n\n"
        . "🛠️ <b>𝗖𝗢𝗠𝗠𝗢𝗡 𝗜𝗦𝗦𝗨𝗘𝗦 𝗪𝗘 𝗙𝗜𝗫:</b>\n"
        . "🔐 <b>𝗔𝗰𝗰𝗼𝘂𝗻𝘁 𝗜𝘀𝘀𝘂𝗲𝘀</b>\n"
        . "💳 <b>𝗥𝗲𝗰𝗵𝗮𝗿𝗴𝗲 / 𝗢𝗿𝗱𝗲𝗿 𝗜𝗦𝘀𝘂𝗲𝘀</b>\n"
        . "💼 <b>𝗦𝗮𝗹𝗲𝘀 𝗢𝗿𝗱𝗲𝗿 𝗣𝗿𝗼𝗯𝗹𝗲𝗺𝘀</b>\n"
        . "⏰ <b>𝗥𝗲𝗺𝗶𝗻𝗱𝗲𝗿 / 𝗔𝗹𝗲𝗿𝘁 𝗜𝘀𝘀𝘂𝗲𝘀</b>\n"
        . "👛 <b>𝗪𝗮𝗹𝗹𝗲𝘁 𝗣𝗿𝗼𝗯𝗹𝗲𝗺𝘀</b>\n"
        . "💰 <b>𝗕𝗮𝗹𝗮𝗻𝗰𝗲 𝗗𝗶𝘀𝗽𝗹𝗮𝘆 𝗜𝘀𝘀𝘂𝗲𝘀</b>\n"
        . "🔁 <b>𝗦𝘄𝗶𝘁𝗰𝗵 𝗧𝗼 𝗠𝗮𝗻𝘂𝗮𝗹 𝗦𝗲𝗿𝘃𝗶𝗰𝗲 𝗣𝗿𝗼𝗯𝗹𝗲𝗺𝘀</b>\n\n"
        . "💡 <b>𝗣𝗥𝗢 𝗧𝗜𝗣:</b> 𝗧𝘆𝗽𝗲 𝗬𝗼𝘂𝗿 𝗣𝗿𝗼𝗯𝗹𝗲𝗺 𝗗𝗶𝗿𝗲𝗰𝘁𝗹𝘆 — 𝗙𝗮𝘀𝘁 𝗥𝗲𝘀𝗽𝗼𝗻𝘀𝗲 ⚡\n\n"
        . "📲 Type <b>/menu</b> or <b>/help</b> 𝗳𝗼𝗿 𝗦𝘂𝗽𝗽𝗼𝗿𝘁\n\n"
        . "⚡ <i>𝗙𝗮𝘀𝘁 • 𝗦𝗮𝗳𝗲 • 𝗙𝘂𝗹𝗹 𝗦𝘂𝗽𝗽𝗼𝗿𝘁 ⚙️</i>";
    // Reply Keyboard
    $keyboard = [
        "keyboard" => [
            ["🔍 𝐒𝐞𝐚𝐫𝐜𝐡 𝐈𝐬𝐬𝐮𝐞"],
            ["🔐 𝐀𝐜𝐜𝐨𝐮𝐧𝐭 𝐈𝐬𝐬𝐮𝐞e", "💳 𝐑𝐞𝐜𝐡𝐚𝐫𝐠𝐞 𝐎𝐫𝐝𝐞𝐫 𝐈𝐬𝐬𝐮𝐞"],
            ["💼 𝐒𝐚𝐥𝐞𝐬 𝐎𝐫𝐝𝐞𝐫 𝐈𝐬𝐬𝐮𝐞", "⏰ R𝐞𝐦𝐢𝐧𝐝𝐞𝐫 𝐈𝐬𝐬𝐮𝐞"],
            ["👛  𝐖𝐚𝐥𝐥𝐞𝐭 𝐈𝐬𝐬𝐮𝐞", "💰 𝐁𝐚𝐥𝐚𝐧𝐜𝐞 𝐈𝐬𝐬𝐮𝐞"],
            ["🔁 𝐌𝐚𝐧𝐮𝐚𝐥 𝐒𝐞𝐫𝐯𝐢𝐜𝐞", "🧩  𝐌𝐞𝐧𝐮", "❓ 𝐇𝐞𝐥𝐩"]
        ],
        "resize_keyboard" => true,       // Makes keyboard fit screen
        "one_time_keyboard" => false     // Keeps keyboard visible
    ];

    $post_fields = [
        "chat_id" => $chat_id,
        "photo" => $photo,
        "caption" => $caption,
        "parse_mode" => "HTML",
        "reply_markup" => json_encode($keyboard)
    ];

    // Send photo
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $post_fields);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);
    curl_close($ch);

    $res = json_decode($response, true);
    return isset($res["ok"]) && $res["ok"] === true;
}




function sendMessage($chat_id, $text, $keyboard = null) {
    global $token;
    $url = "https://api.telegram.org/bot$token/sendMessage";
    $params = [
        "chat_id" => $chat_id,
        "text" => $text,
        "parse_mode" => "HTML",
        "disable_web_page_preview" => true
    ];
    if ($keyboard) {
        $params["reply_markup"] = json_encode(["inline_keyboard" => $keyboard]);
    }

    // Use cURL instead of file_get_contents to capture response properly
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $params);
    $response = curl_exec($ch);
    curl_close($ch);

    // Decode JSON response
    $res = json_decode($response, true);

    // Return true if message was sent successfully, false otherwise
    return isset($res["ok"]) && $res["ok"] === true;
}

function editMessage($chat_id, $message_id, $text, $keyboard = null) {
    global $token;
    $url = "https://api.telegram.org/bot$token/editMessageText";
    $params = [
        "chat_id" => $chat_id,
        "message_id" => $message_id,
        "text" => $text,
        "parse_mode" => "HTML"
    ];
    if ($keyboard) $params["reply_markup"] = json_encode(["inline_keyboard" => $keyboard]);
    file_get_contents($url . "?" . http_build_query($params));
}

function saveIssue($entry) {
    $file = USER_ISSUE_FILE;
    $data = [];
    if (file_exists($file)) $data = json_decode(file_get_contents($file), true) ?? [];
    $data[] = $entry;
    file_put_contents($file, json_encode($data, JSON_PRETTY_PRINT));
}

function updateIssueStatus($ticket, $status) {
    $file = USER_ISSUE_FILE;
    if (!file_exists($file)) return;
    $data = json_decode(file_get_contents($file), true);
    foreach ($data as &$entry) {
        if ($entry["ticket"] == $ticket) {
            $entry["status"] = $status;
        }
    }
    file_put_contents($file, json_encode($data, JSON_PRETTY_PRINT));
}

function registerUser($id, $name, $username) {
    $file = USER_DATA_FILE;
    $data = [];
    if (file_exists($file)) $data = json_decode(file_get_contents($file), true) ?? [];
    if (!isset($data[$id])) {
        $data[$id] = [
            "name" => $name,
            "username" => $username,
            "telegram_id" => $id,
            "joined" => date("Y-m-d H:i:s")
        ];
        file_put_contents($file, json_encode($data, JSON_PRETTY_PRINT));
    }
}

function broadcastMessage($text) {
    global $token;
    $data = json_decode(file_get_contents(USER_DATA_FILE), true) ?? [];
    foreach ($data as $u) {
        file_get_contents("https://api.telegram.org/bot$token/sendMessage?" . http_build_query([
            "chat_id" => $u["telegram_id"],
            "text" => $text,
            "parse_mode" => "HTML"
        ]));
    }
}

function getIssueStats() {
    $issues = json_decode(file_get_contents(USER_ISSUE_FILE), true) ?? [];
    $users = json_decode(file_get_contents(USER_DATA_FILE), true) ?? [];
    $stats = ["total"=>0,"resolved"=>0,"pending"=>0,"rejected"=>0,"users"=>count($users)];
    foreach ($issues as $i) {
        $stats["total"]++;
        $stats[$i["status"]]++;
    }
    return $stats;
}
?>
